<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Permission\Exodus\Actions\RemoveDuplicateAuthenticatedPrivileges\RemoveDuplicateAuthenticatedPrivilegesBackofficeSections;
use Inside\Permission\Exodus\Actions\RemoveDuplicateAuthenticatedPrivileges\RemoveDuplicateAuthenticatedPrivilegesCategorizable;
use Inside\Permission\Exodus\Actions\RemoveDuplicateAuthenticatedPrivileges\RemoveDuplicateAuthenticatedPrivilegesContentType;
use Inside\Permission\Exodus\Actions\RemoveDuplicateAuthenticatedPrivileges\RemoveDuplicateAuthenticatedPrivilegesMenu;
use Inside\Permission\Services\PermissionService;

class RemoveDuplicateAuthenticatedPrivileges extends Migration
{
    public function up() : void
    {
        if (! PermissionService::isSystemV2Initialized()) {
            return;
        }

        (new RemoveDuplicateAuthenticatedPrivilegesMenu())->execute();
        (new RemoveDuplicateAuthenticatedPrivilegesContentType())->execute();
        (new RemoveDuplicateAuthenticatedPrivilegesCategorizable())->execute();
        (new RemoveDuplicateAuthenticatedPrivilegesBackofficeSections())->execute();
    }
}
