<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Permission\Exodus\Actions\ConvertOldPermissions\ConvertOldBackofficePermissions;
use Inside\Permission\Exodus\Actions\ConvertOldPermissions\ConvertOldCategorizableContentPermissions;
use Inside\Permission\Exodus\Actions\ConvertOldPermissions\ConvertOldContentSpecificPermissions;
use Inside\Permission\Exodus\Actions\ConvertOldPermissions\ConvertOldContentTypePermissions;
use Inside\Permission\Exodus\Actions\ConvertOldPermissions\ConvertOldMenuPermissions;
use Inside\Permission\Exodus\Models\Role;
use Inside\Permission\Services\PermissionService;

class ConvertOldPermissionsToPrivileges extends Migration
{
    public function up() : void
    {
        if (! PermissionService::isSystemV2Initialized()) {
            return;
        }

        Artisan::call('models:rebuild');

        (new ConvertOldMenuPermissions())->execute();
        (new ConvertOldBackofficePermissions())->execute();
        (new ConvertOldContentTypePermissions())->execute();
        (new ConvertOldContentSpecificPermissions())->execute();
        (new ConvertOldCategorizableContentPermissions())->execute();
    }
}
