<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Inside\Permission\Exodus\Models\Capability;
use Inside\Permission\Exodus\Models\Privileges\ContentPrivilege;

class CreateContentPrivilegesTable extends Migration
{
    const CAPABILITY_FOREIGN = ContentPrivilege::TABLE.'_cap_foreign';

    const ROLE_FOREIGN = ContentPrivilege::TABLE.'_role_foreign';

    public function up() : void
    {
        Schema::create(ContentPrivilege::TABLE, function (Blueprint $table) {
            $table->increments('id')->index();
            $table->integer('capability_id')->unsigned();
            $table->string('uuid')->index();

            $table->foreign('capability_id', self::CAPABILITY_FOREIGN)
                ->references('id')
                ->on(Capability::TABLE)
                ->onDelete('cascade');
        });
    }

    public function down() : void
    {
        Schema::table(ContentPrivilege::TABLE, function (Blueprint $table) {
            $table->dropForeign(self::CAPABILITY_FOREIGN);
        });

        Schema::dropIfExists(ContentPrivilege::TABLE);
    }
}
