<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Inside\Permission\Exodus\Models\Privileges\ContentTypePrivilege;
use Inside\Permission\Exodus\Models\Role;

class CreateContentTypePrivilegeRolePivotTable extends Migration
{
    const ROLE_FOREIGN = ContentTypePrivilege::PIVOT_ROLE_TABLE.'_role_foreign';

    const CONTENT_TYPE_FOREIGN = ContentTypePrivilege::PIVOT_ROLE_TABLE.'_ctp_foreign';

    public function up() : void
    {
        Schema::create(ContentTypePrivilege::PIVOT_ROLE_TABLE, function (Blueprint $table) {
            $table->increments('pivot_id')->index();
            $table->integer('role_id')->unsigned();
            $table->integer('content_type_privilege_id')->unsigned();

            $table->foreign('role_id', self::ROLE_FOREIGN)
                ->references('id')
                ->on(Role::TABLE)
                ->onDelete('cascade');

            $table->foreign('content_type_privilege_id', self::CONTENT_TYPE_FOREIGN)
                ->references('id')
                ->on(ContentTypePrivilege::TABLE)
                ->onDelete('cascade');
        });
    }

    public function down() : void
    {
        Schema::table(ContentTypePrivilege::PIVOT_ROLE_TABLE, function (Blueprint $table) {
            $table->dropForeign(self::ROLE_FOREIGN);
            $table->dropForeign(self::CONTENT_TYPE_FOREIGN);
        });

        Schema::dropIfExists(ContentTypePrivilege::PIVOT_ROLE_TABLE);
    }
}
