<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Inside\Permission\Exodus\Models\Privileges\BackofficePrivilege;
use Inside\Permission\Exodus\Models\Role;

class CreateBackofficePrivilegeRolePivotTable extends Migration
{
    const ROLE_FOREIGN = BackofficePrivilege::PIVOT_ROLE_TABLE.'_role_foreign';

    const BACKOFFICE_FOREIGN = BackofficePrivilege::PIVOT_ROLE_TABLE.'_bs_foreign';

    public function up() : void
    {
        Schema::create(BackofficePrivilege::PIVOT_ROLE_TABLE, function (Blueprint $table) {
            $table->increments('pivot_id')->index();
            $table->integer('role_id')->unsigned();
            $table->integer('backoffice_section_id')->unsigned();

            $table->foreign('role_id', self::ROLE_FOREIGN)
                ->references('id')
                ->on(Role::TABLE)
                ->onDelete('cascade');

            $table->foreign('backoffice_section_id', self::BACKOFFICE_FOREIGN)
                ->references('id')
                ->on(BackofficePrivilege::TABLE)
                ->onDelete('cascade');
        });
    }

    public function down() : void
    {
        Schema::table(BackofficePrivilege::PIVOT_ROLE_TABLE, function (Blueprint $table) {
            $table->dropForeign(self::ROLE_FOREIGN);
            $table->dropForeign(self::BACKOFFICE_FOREIGN);
        });

        Schema::dropIfExists(BackofficePrivilege::PIVOT_ROLE_TABLE);
    }
}
