<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Inside\Permission\Exodus\Models\Capability;
use Inside\Permission\Exodus\Models\Privileges\MenuPrivilege;

class CreateMenuPrivilegesTable extends Migration
{
    const CAPABILITY_FOREIGN = MenuPrivilege::TABLE.'_cap_foreign';

    public function up() : void
    {
        Schema::create(MenuPrivilege::TABLE, function (Blueprint $table) {
            $table->increments('id')->index();
            $table->integer('capability_id')->unsigned();
            $table->string('index_uuid');

            $table->foreign('capability_id', self::CAPABILITY_FOREIGN)
                ->on(Capability::TABLE)
                ->references('id')
                ->onDelete('cascade');
        });
    }

    public function down() : void
    {
        Schema::table(MenuPrivilege::TABLE, function (Blueprint $table) {
            $table->dropForeign(self::CAPABILITY_FOREIGN);
        });

        Schema::dropIfExists(MenuPrivilege::TABLE);
    }
}
