<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Inside\Permission\Exodus\Models\Capability;
use Inside\Permission\Exodus\Models\Privileges\BackofficePrivilege;
use Inside\Permission\Exodus\Models\Privileges\CategorizableContentPrivilege;
use Inside\Permission\Exodus\Models\Privileges\ContentPrivilege;
use Inside\Permission\Exodus\Models\Privileges\ContentSpecificPrivilege;
use Inside\Permission\Exodus\Models\Privileges\ContentTypePrivilege;
use Inside\Permission\Exodus\Models\Privileges\MenuPrivilege;
use Inside\Permission\Exodus\Services\ViewIndexer\CategorizableContentTranslationViewIndexer;
use Inside\Permission\Exodus\Services\ViewIndexer\CategorizableContentViewIndexer;
use Inside\Permission\Exodus\Services\ViewIndexer\ContentTranslationViewIndexer;
use Inside\Permission\Exodus\Services\ViewIndexer\MenuViewIndexer;

class ClearTablesPreRefacto extends Migration
{
    private array $tables = [
        BackofficePrivilege::PIVOT_ROLE_TABLE,
        CategorizableContentPrivilege::PIVOT_ROLE_TABLE,
        ContentTypePrivilege::PIVOT_ROLE_TABLE,
        ContentPrivilege::PIVOT_ROLE_TABLE,
        ContentSpecificPrivilege::PIVOT_ROLE_TABLE,
        MenuPrivilege::PIVOT_ROLE_TABLE,
        BackofficePrivilege::TABLE,
        CategorizableContentPrivilege::TABLE,
        ContentTypePrivilege::TABLE,
        ContentPrivilege::TABLE,
        ContentSpecificPrivilege::TABLE,
        MenuPrivilege::TABLE,
        MenuViewIndexer::TABLE,
        Capability::TABLE,
        CategorizableContentTranslationViewIndexer::TABLE,
        CategorizableContentViewIndexer::TABLE,
        ContentTranslationViewIndexer::TABLE,
    ];

    public $withinTransaction = false;

    public function up(): void
    {
        foreach ($this->tables as $table) {
            Schema::dropIfExists($table);
        }
    }
}
