<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class EnforceUniqueToTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $schemaManager = Schema::getConnection()->getDoctrineSchemaManager();

        $this->removeDuplicates('inside_users_roles', ['user_uuid', 'role_id']);
        $this->removeDuplicates(
            'inside_roles_permissions_schema',
            ['role_id', 'permission_schema_id', 'is_content_specific']
        );
        $this->removeDuplicates('inside_users_permissions_schema', ['user_uuid', 'permission_schema_id']);
        $this->removeDuplicates(
            'inside_permissions_schema',
            ['invert', 'children', 'action', 'authorizable_type', 'authorizable_uuid']
        );
        $this->removeDuplicates('inside_permissions', ['role_id', 'action', 'uuid', 'type']);
        $this->removeDuplicates('inside_permissions', ['user_uuid', 'action', 'uuid', 'type']);

        $indexesFound = $schemaManager->listTableIndexes('inside_users_roles');

        if (! array_key_exists('roles_users_unique', $indexesFound)) {
            Schema::table(
                'inside_users_roles',
                function (Blueprint $table) {
                    $table->unique(['user_uuid', 'role_id'], 'roles_users_unique');
                }
            );
        }

        $indexesFound = $schemaManager->listTableIndexes('inside_roles_permissions_schema');

        if (! array_key_exists('roles_permission_unique', $indexesFound)) {
            Schema::table(
                'inside_roles_permissions_schema',
                function (Blueprint $table) {
                    $table->unique(
                        ['role_id', 'permission_schema_id', 'is_content_specific'],
                        'roles_permission_unique'
                    );
                }
            );
        }

        $indexesFound = $schemaManager->listTableIndexes('inside_users_permissions_schema');

        if (! array_key_exists('users_permission_unique', $indexesFound)) {
            Schema::table(
                'inside_users_permissions_schema',
                function (Blueprint $table) {
                    $table->unique(['user_uuid', 'permission_schema_id'], 'users_permission_unique');
                }
            );
        }

        $indexesFound = $schemaManager->listTableIndexes('inside_permissions_schema');

        if (! array_key_exists('schema_unique', $indexesFound)) {
            Schema::table(
                'inside_permissions_schema',
                function (Blueprint $table) {
                    $table->unique(
                        [
                            'invert',
                            'children',
                            'action',
                            'authorizable_type',
                            'authorizable_uuid',
                        ],
                        'schema_unique'
                    );
                }
            );
        }

        $indexesFound = $schemaManager->listTableIndexes('inside_permissions');

        if (! array_key_exists('role_unique', $indexesFound)) {
            Schema::table(
                'inside_permissions',
                function (Blueprint $table) {
                    $table->unique(
                        [
                            'role_id',
                            'action',
                            'uuid',
                            'type',
                        ],
                        'role_unique'
                    );
                }
            );
        }

        if (! array_key_exists('user_unique', $indexesFound)) {
            Schema::table(
                'inside_permissions',
                function (Blueprint $table) {
                    $table->unique(
                        [
                            'user_uuid',
                            'action',
                            'uuid',
                            'type',
                        ],
                        'user_unique'
                    );
                }
            );
        }
    }

    /**
     * Attempts to remove duplicates lines
     *
     * @param string $table
     * @param array  $columns
     * @return bool
     */
    protected function removeDuplicates(string $table, array $columns)
    {
        $deletes =
            DB::table($table)->selectRaw('id, '.implode(', ', $columns).', COUNT(*) as CNT')->groupBy($columns)
                ->havingRaw('COUNT(*) > 1')->get()->pluck('id')->toArray();

        if (count($deletes)) {
            DB::table($table)->whereIn('id', $deletes)->delete();

            $this->removeDuplicates($table, $columns);

            return false;
        }

        return true;
    }
}
