<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class AddUniqueToUsersRolesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        try {
            DB::statement('SET FOREIGN_KEY_CHECKS=0;');

            Schema::table(
                'inside_users_roles',
                function (Blueprint $table) {
                    $table->unique(['user_uuid', 'role_id'], 'roles_users_unique');
                }
            );

            DB::statement('SET FOREIGN_KEY_CHECKS=1;');
        } catch (Exception $e) {
            //
        }
    }
}
