=<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddIndexToPermissionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table(
            'inside_permissions',
            function (Blueprint $table) {
                $table->index(['uuid', 'action', 'role_id']);
                $table->index(['uuid', 'action', 'user_uuid']);
            }
        );

        Schema::table(
            'inside_permissions_schema',
            function (Blueprint $table) {
                $table->index(['action', 'authorizable_type']);
                $table->index(['action', 'authorizable_uuid']);
            }
        );
    }
}
