<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class AlterRolesPermissionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        try {
            DB::statement('SET FOREIGN_KEY_CHECKS=0;');

            Schema::table(
                'inside_roles_permissions',
                function (Blueprint $table) {
                    $table->dropForeign('inside_roles_permissions_permission_id_foreign');

                    $table->renameColumn('permission_id', 'permission_schema_id');
                    $table->foreign('permission_schema_id')->references('id')->on('inside_permissions_schema')
                        ->onDelete('cascade');
                }
            );

            Schema::rename('inside_roles_permissions', 'inside_roles_permissions_schema');

            Schema::table(
                'inside_users_permissions',
                function (Blueprint $table) {
                    $table->dropForeign('inside_users_permissions_permission_id_foreign');
                    $table->renameColumn('permission_id', 'permission_schema_id');
                    $table->foreign('permission_schema_id')->references('id')->on('inside_permissions_schema')
                        ->onDelete('cascade');
                }
            );

            Schema::rename('inside_users_permissions', 'inside_users_permissions_schema');

            DB::statement('SET FOREIGN_KEY_CHECKS=1;');
        } catch (Exception $e) {
            //
        }
    }
}
