<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class AlterRolesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        try {
            DB::statement('SET FOREIGN_KEY_CHECKS=0;');

            Schema::create(
                'inside_roles_categories',
                function (Blueprint $table) {
                    $table->increments('id');
                    $table->string('name');
                    $table->integer('pid')->collate('utf8')->unsigned()->nullable();
                }
            );

            if (Schema::hasTable('inside_roles')) {
                Schema::table(
                    'inside_roles',
                    function (Blueprint $table) {
                        $table->integer('pid')->collate('utf8')->unsigned()->nullable();
                        $table->integer('role_category_id')->collate('utf8')->unsigned()->nullable();
                        $table->tinyInteger('is_automatic')->default(0);
                        $table->longText('condition')->nullable();

                        $table->foreign('role_category_id')->references('id')->on('inside_roles_categories');
                    }
                );
            }

            DB::statement('SET FOREIGN_KEY_CHECKS=1;');
        } catch (Exception $e) {
            //
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('inside_roles_categories');
    }
}
