<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePermissionsSchemaTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create(
            'inside_permissions_schema',
            function (Blueprint $table) {
                $table->increments('id')->collate('utf8');
                $table->tinyInteger('invert')->default(0);
                $table->tinyInteger('children')->default(0);
                $table->string('action', 255)->nullable();
                $table->string('authorizable_type', 255)->nullable();
                $table->uuid('authorizable_uuid')->collate('utf8')->nullable();
                $table->string('field_name', 255)->nullable();
                $table->string('field_value', 255)->nullable();
                $table->longText('condition')->nullable();
                $table->string('custom', 255)->nullable();
            }
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('inside_permissions_schema');
    }
}
