<?php

use Illuminate\Support\Facades\Route;

Route::group(
    [
        'namespace'  => 'Inside\Notify\Http\Controllers',
        'prefix'     => 'api/v1',
        'middleware' => 'auth.api',
    ],
    function ($router) {
        $router->get('notifications', ['uses' => 'NotificationController@list']);

        $router->get('notifications/log/{type}/{uuid}', ['uses' => 'NotificationLogController@get']);
        $router->delete('notifications/log/{notificationLogId}', ['uses' => 'NotificationLogController@delete']);

        $router->post('notifications/follow/user/{uuid}', ['uses' => 'NotificationTypeController@followUser']);
        $router->delete('notifications/unfollow/user/{uuid}', ['uses' => 'NotificationTypeController@unfollowUser']);

        $router->get(
            'notifications/{action}/{type}/{uuid}[/{days}]',
            ['uses' => 'NotificationController@getForAContent']
        );

        $router->put('notifications/view/all', ['uses' => 'NotificationController@viewAll']);
        $router->put('notifications/view/{id}', ['uses' => 'NotificationController@view']);

        $router->put('notifications/read/all', ['uses' => 'NotificationController@readAll']);
        $router->put('notifications/read/{id}', ['uses' => 'NotificationController@read']);

        $router->get('notification/types', ['uses' => 'NotificationTypeController@list']);
        $router->get('notification/types/{notificationTypeId}', ['uses' => 'NotificationTypeController@get']);

        $router->post('notifications/dispatch', ['uses' => 'NotificationController@dispatch']);

        $router->post('notifications/subscribe/{notificationTypeId}', ['uses' => 'NotificationSubscriberController@subscribe']);
        $router->delete('notifications/subscribe/{notificationTypeId}', ['uses' => 'NotificationSubscriberController@unsubscribe']);

        $router->post('notification/types/subscribe', ['uses' => 'NotificationTypeController@subscribe']);
        $router->delete('notification/types/subscribe', ['uses' => 'NotificationTypeController@unsubscribe']);

        $router->post('notification/types', ['uses' => 'NotificationTypeController@create']);
        $router->put('notification/types/{notificationTypeId}', ['uses' => 'NotificationTypeController@update']);
        $router->delete('notification/types/{notificationTypeId}', ['uses' => 'NotificationTypeController@delete']);

        $router->post('notification/push/devices', ['uses' => 'NotificationPushDeviceController@post']);
        $router->get('notification/push/devices', ['uses' => 'NotificationPushDeviceController@list']);
        $router->delete('notification/push/devices/{playerId}', ['uses' => 'NotificationPushDeviceController@delete']);
    }
);

Route::group(
    [
        'namespace'  => 'Inside\Notify\Http\Controllers',
        'prefix'     => 'api/v1',
        'middleware' => 'auth.maecia',
    ],
    function ($router) {
        $router->get(
            'notifications/subscribers/{id}',
            [
                'uses' => 'NotificationSubscriberController@listSubscribers',
            ]
        );
        $router->post(
            'notifications/subscribers/{id}',
            [
                'uses' => 'NotificationSubscriberController@addSubscribers',
            ]
        );
        $router->delete(
            'notifications/subscribers/{id}',
            [
                'uses' => 'NotificationSubscriberController@removeSubscribers',
            ]
        );
        $router->get(
            'notification/test',
            [
                'uses'       => 'NotificationController@test',
                'alias'      => 'notification.test',
            ]
        );
    }
);

Route::group([
    'namespace'  => 'Inside\Notify\Http\Controllers',
    'prefix' => '',
], function ($router) {
    $router->get('notify_content_files/{contentType}/{contentUuid}', ['uses' => 'ContentUrlController@serve']);
});
