<?php

namespace Inside\Notify\Validators;

use Illuminate\Validation\Validator;
use Inside\Notify\Exceptions\NotificationTypeValidatorException;

/**
 * Notification Type validator.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class NotificationTypeValidator
{
    /**
     * @var array
     */
    protected $rules = [
        'via'       => 'required|in:web,email,sms,push',
        'default'   => 'boolean',
        'event'     => 'required|string',
        'model'     => 'required|string',
        'action'    => 'required|string',
        'condition' => 'required|string',
        // 'data'      => 'nullable|json',
        'multiple'  => 'boolean',
    ];

    /**
     * Validate data with given rules
     *
     * @param  mixed $data
     * @return void
     * @throws NotificationTypeValidatorException
     */
    public function validate($data): void
    {
        $validator = \Validator::make($data, $this->rules);

        if ($validator->fails()) {
            $errors = $this->formatErrors($validator);

            throw new NotificationTypeValidatorException(implode(' ', $errors), 400);
        }
    }

    /**
     * @param  Validator  $validator
     * @return array
     */
    protected function formatErrors(Validator $validator): array
    {
        $errors = [];
        $messages = $validator->getMessageBag();

        foreach ($messages->keys() as $key) {
            $errors[$key] = implode('\\n', $messages->get($key));
        }

        return $errors;
    }
}
