<?php

namespace Inside\Notify\Services;

use Inside\Notify\Messages\SmsMessage;
use Inside\Notify\Notifications\InsideNotification;

interface SmsDriverServiceInterface
{
    public function isAvailable(): bool;

    public function overQuota(): bool;

    /** @param mixed $message */
    public function send($message): bool;

    /** @return mixed */
    public function getMessageFromNotification(InsideNotification $notification);

    public function getRemainingCreditsForCurrentPlan(): ?float;

    public function getCurrency(): ?string;
}
