<?php

namespace Inside\Notify\Services;

use Inside\Notify\Models\SmsQuota;

class SmsDriverService
{
    protected ?string $currency = null;

    /**
     * @param  array  $config
     * @param  string|null  $sender
     * @param  string|null  $mobileFieldName
     * @param  int|null  $quota
     */
    public function __construct(
        protected array $config,
        protected ?string $sender = null,
        protected ?string $mobileFieldName = null,
        protected ?int $quota = null
    ) {
    }

    /**
     * Get allowed sent sms per plan from config
     *
     * @return int|null
     */
    public function getQuota(): ?int
    {
        return $this->quota;
    }

    /**
     * @return SmsQuota|null
     */
    protected function getQuotaForCurrentMonth(): ?SmsQuota
    {
        return SmsQuota::whereMonth('created_at', now()->format('m'))
            ->whereYear('created_at', now()->format('Y'))->first();
    }

    protected function addSmsCount(int $smsCount): void
    {
        $quota = $this->getQuotaForCurrentMonth();
        if (is_null($quota)) {
            SmsQuota::create([
                'sms_count' => $smsCount,
            ]);

            return;
        }
        $quota->increment('sms_count', $smsCount);
    }

    /**
     * @return int
     */
    public function getSmsCountForCurrentMonth(): int
    {
        $quota = $this->getQuotaForCurrentMonth();
        if (is_null($quota)) {
            return 0;
        }

        return $quota->sms_count;
    }

    /**
     * @return string|null
     */
    public function getCurrency(): ?string
    {
        if (is_null($this->currency)) {
            (string) $this->getRemainingCreditsForCurrentPlan();
        }

        return $this->currency;
    }
}
