<?php

namespace Inside\Notify\Services;

use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;
use Inside\Notify\Models\NotificationTypeRole;
use Inside\Permission\Models\Role;

class NotificationTypeHelper
{
    /**
     * Subscribe one or several roles to one notification type.
     *
     * @param  NotificationType  $type
     * @param  string|array  $roleNames
     * @param  bool  $subscribeMembers
     */
    public function subscribeRoles(NotificationType $type, $roleNames, bool $subscribeMembers): void
    {
        if (is_string($roleNames)) {
            $roleNames = [$roleNames];
        }

        $roles = Role::whereIn('name', $roleNames)->get();
        $roles->each(
            function ($role) use ($type, $subscribeMembers) {
                NotificationTypeRole::firstOrCreate(
                    [
                        'role_id' => $role->id,
                        'notification_type_id' => $type->id,
                    ]
                );

                if ($subscribeMembers) {
                    $role->users->each(
                        function ($user) use ($type) {
                            NotificationSubscriber::firstOrCreate(
                                [
                                    'user_uuid' => $user->uuid,
                                    'notification_type_id' => $type->id,
                                ]
                            );
                        }
                    );
                }
            }
        );
    }
}
