<?php

namespace Inside\Notify\Services;

use Exception;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Users;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;

/**
 * Notification Subscriber service.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ManualNotificationsService
{
    private const NOTIFICATION_TYPE_ACTION = 'manualNotificationsSend';

    public function webChanelSubscribers(): Collection
    {
        $notificationType = $this->manualNotificationTypeForChannel('web');

        return $notificationType->subscribers()->get();
    }

    public function notificationTypeForEmail(): NotificationType
    {
        return $this->manualNotificationTypeForChannel('email');
    }

    public function manualNotificationTypeForChannel(string $chanel): NotificationType
    {
        return NotificationType::where([
            'via' => $chanel,
            'action' => self::NOTIFICATION_TYPE_ACTION,
        ])->first();
    }
}
