<?php

namespace Inside\Notify\Services;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;
use Inside\Settings\Models\Setting;

trait HasSpecialLanguageKeys
{
    /**
     * Get a translation key
     *
     * @param  string  $translationKey
     * @param  Model  $model
     * @param  array  $data
     * @return string
     */
    public function getTranslationKey(string $translationKey, Model $model, array $data = []): string
    {
        $matches = [];
        $result = $translationKey;
        if (preg_match_all('#<([^>]+)>#', $translationKey, $matches) !== false) {
            foreach ($matches[0] as $key => $found) {
                $properties = explode('.', $matches[1][$key]);
                $value = null;
                foreach ($properties as $property) {
                    if ($value !== null) {
                        $value = $value->{$property};
                    } else {
                        $value = $model->{$property};
                    }
                    if ($value === null && array_key_exists($property, $data)) {
                        $data = $value = $data[$property];
                    }
                    if ($value === null) {
                        break;
                    }
                }
                if ($value !== null) {
                    $result = str_replace($found, $value, $result);

                    // Fallback if translation does not exist
                    if (__($result) == $result) {
                        $result = str_replace('.'.$value, '', $result);
                    }
                } else {
                    $result = str_replace('.'.$found, '', $result);
                }
            }
        }

        return $result;
    }

    public function getTranslationFromSettings(string $viewName, string $translationName, string $langCode, string $contentType): ?string
    {
        $translationKey = Str::snake($viewName).'_'.$translationName.'_'.$langCode;

        return Setting::where(['group' => $contentType, 'key' => $translationKey])->first()?->value;
    }
}
