<?php

namespace Inside\Notify\Notifications;

use Inside\Authentication\Models\User;
use Inside\Authentication\Models\User as AuthenticationUser;
use Inside\Content\Models\Content;
use Inside\Content\Models\Contents\Users as ContentUser;
use Inside\Notify\Channels\DatabaseChannel;
use Inside\Notify\Models\NotificationType;
use Inside\Permission\Models\User as PermissionUser;

/**
 * Web notification.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class WebNotification extends InsideNotification
{
    public function __construct(
        protected NotificationType $notificationType,
        protected ?User $user,
        protected ?Content $model,
        protected ?array $data = [],
        protected ?array $roles = [],
    ) {
        parent::__construct($notificationType, $user, $model, $data);
    }

    public function via(): array
    {
        return [DatabaseChannel::class];
    }

    public function toDatabase(mixed $notifiable): array
    {
        // HARDCODE
        $parent = null;

        if (! is_null($this->model) && method_exists($this->model, 'groups')) {
            //TODO : check this weird stuff ( maybe useless )
            $parent = $this->model->groups->first()->uuid;
        }

        // If a specific url is given in data, use this one instead
        $this->data['url'] = $this->getContentUrl();
        $locale = null;
        if (
            $this->model && ! in_array(
                get_class($this->model),
                [ContentUser::class, PermissionUser::class, AuthenticationUser::class]
            )
        ) {
            $locale = $this->model->langcode;
        }

        return [
            'notification_type_id' => $this->notificationType->id,
            'type' => $this->notificationType->type,
            'parent' => $parent,
            'user_uuid' => $this->user?->uuid,
            'notifiable_type' => $this->model ? get_class($this->model) : '',
            'notifiable_uuid' => $this->model ? $this->model->getKey() : '',
            'notifiable_langcode' => $locale,
            'data' => $this->data,
            'author_uuid' => $this->data['from'] ?? null,
            'roles' => $this->roles ?? [],
        ];
    }
}
