<?php

namespace Inside\Notify\Notifications;

use Illuminate\Support\Facades\Lang;
use Inside\Notify\Channels\SlackChannel;

/**
 * Slack notification.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class SlackNotification extends InsideNotification
{
    /**
     * @param mixed $notifiable
     * @return array
     */
    public function via($notifiable): array
    {
        return [SlackChannel::class];
    }

    /**
     * @return array
     */
    public function toSlack(): array
    {
        // TODO : URL + Replace title / author etc...
        return [
            'title' => Lang::get($this->notificationType->data['mail']['subject']), // @phpstan-ignore-line
        ];
    }
}
