<?php

namespace Inside\Notify\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Inside Notification Subscriber model.
 *
 * @category Class
 * @author Maecia <technique@maecia.com>
 * @license http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link http://www.maecia.com/
 * @property int $id
 * @property int $notification_type_id
 * @property int $role_id
 * @property-read NotificationType $notificationType
 * @method static Builder|NotificationTypeRole newModelQuery()
 * @method static Builder|NotificationTypeRole newQuery()
 * @method static Builder|NotificationTypeRole query()
 * @method static Builder|NotificationTypeRole whereId($value)
 * @method static Builder|NotificationTypeRole whereNotificationTypeId($value)
 * @method static Builder|NotificationTypeRole whereRoleId($value)
 *
 * @mixin Builder
 * @mixin \Eloquent
 */
class NotificationTypeRole extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'inside_notifications_type_role';

    /**
     * The table without the timestamps.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'role_id',
        'notification_type_id',
    ];

    /**
     * The notification type
     */
    public function notificationType(): BelongsTo
    {
        return $this->belongsTo(NotificationType::class, 'notification_type_id', 'id');
    }
}
