<?php

namespace Inside\Notify\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Inside\Authentication\Models\User;
use Inside\Database\Eloquent\WithEnhancedBuilder;
use Inside\Permission\Models\Role;

/**
 * @property int $id
 * @property string|null $via
 * @property int $default
 * @property string|null $event
 * @property string|null $model
 * @property string|null $type
 * @property string|null $action
 * @property string|null $condition
 * @property int $multiple
 * @property int $language
 * @property int $profile
 * @property array|null $data
 * @property int $role
 * @property-read \Illuminate\Notifications\DatabaseNotificationCollection|\Inside\Notify\Models\Notification[] $notifications
 * @property-read int|null $notifications_count
 * @property-read \Illuminate\Database\Eloquent\Collection|Role[] $roles
 * @property-read int|null $roles_count
 * @property-read \Illuminate\Database\Eloquent\Collection|User[] $subscribers
 * @property-read int|null $subscribers_count
 * @method static Builder|NotificationType newModelQuery()
 * @method static Builder|NotificationType newQuery()
 * @method static Builder|NotificationType query()
 * @method static Builder|NotificationType whereAction($value)
 * @method static Builder|NotificationType whereCondition($value)
 * @method static Builder|NotificationType whereData($value)
 * @method static Builder|NotificationType whereDefault($value)
 * @method static Builder|NotificationType whereEvent($value)
 * @method static Builder|NotificationType whereId($value)
 * @method static Builder|NotificationType whereLanguage($value)
 * @method static Builder|NotificationType whereModel($value)
 * @method static Builder|NotificationType whereMultiple($value)
 * @method static Builder|NotificationType whereProfile($value)
 * @method static Builder|NotificationType whereRole($value)
 * @method static Builder|NotificationType whereType($value)
 * @method static Builder|NotificationType whereVia($value)
 * @method static Builder|NotificationType where($column, $operator = null, $value = null, $boolean = 'and')
 *
 * @mixin Builder
 * @mixin \Eloquent
 */
class NotificationType extends Model
{
    use WithEnhancedBuilder;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'inside_notifications_types';

    /**
     * Casts the following attributes
     *
     * @var array
     */
    protected $casts = [
        'data' => 'array',
    ];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $guarded = [];

    /**
     * The table without the timestamps.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * Users subscribes to this type
     *
     * @return BelongsToMany
     */
    public function subscribers(): BelongsToMany
    {
        return $this->belongsToMany(
            User::class,
            'inside_notifications_subscribers',
            'notification_type_id',
            'user_uuid'
        );
    }

    /**
     * Roles subscribes to this type
     *
     * @return BelongsToMany
     */
    public function roles(): BelongsToMany
    {
        return $this->belongsToMany(
            Role::class,
            'inside_notifications_type_role',
            'notification_type_id',
            'role_id'
        );
    }

    /**
     * Get notifications of this type
     *
     * @return HasMany
     */
    public function notifications(): HasMany
    {
        return $this->hasMany(Notification::class, 'notification_type_id', 'id');
    }
}
