<?php

namespace Inside\Notify\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Inside\Authentication\Models\User;
use Inside\Notify\Models\NotificationType;

/**
 * Inside Notification Subscriber model.
 *
 * @category Class
 * @author Maecia <technique@maecia.com>
 * @license http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link http://www.maecia.com/
 * @property int $id
 * @property string $user_uuid
 * @property int $notification_type_id
 * @property-read NotificationType $notificationType
 * @property-read User $user
 * @method static Builder|NotificationSubscriber newModelQuery()
 * @method static Builder|NotificationSubscriber newQuery()
 * @method static Builder|NotificationSubscriber query()
 * @method static Builder|NotificationSubscriber whereId($value)
 * @method static Builder|NotificationSubscriber whereNotificationTypeId($value)
 * @method static Builder|NotificationSubscriber whereUserUuid($value)
 *
 * @mixin Builder
 * @mixin \Eloquent
 */
class NotificationSubscriber extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'inside_notifications_subscribers';

    /**
     * The table without the timestamps.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_uuid',
        'notification_type_id',
    ];

    /**
     * The notification type
     */
    public function notificationType(): BelongsTo
    {
        return $this->belongsTo(NotificationType::class, 'notification_type_id', 'id');
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo('Inside\Authentication\Models\User', 'user_uuid', 'uuid');
    }
}
