<?php

namespace Inside\Notify\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Inside Notification Subscriber model.
 *
 * @category Class
 * @author Maecia <technique@maecia.com>
 * @license http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link http://www.maecia.com/
 * @property int $id
 * @property int $notification_id
 * @property int $role_id
 * @property-read Notification $notification
 * @method static Builder|NotificationRole newModelQuery()
 * @method static Builder|NotificationRole newQuery()
 * @method static Builder|NotificationRole query()
 * @method static Builder|NotificationRole whereId($value)
 * @method static Builder|NotificationRole whereNotificationId($value)
 * @method static Builder|NotificationRole whereRoleId($value)
 *
 * @mixin \Eloquent
 * @mixin Builder
 */
class NotificationRole extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'inside_notification_role';

    /**
     * The table without the timestamps.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'role_id',
        'notification_id',
    ];

    /**
     * The notification type
     */
    public function notification(): BelongsTo
    {
        return $this->belongsTo(Notification::class, 'notification_id', 'id');
    }
}
