<?php

namespace Inside\Notify\Listeners;

use Exception;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Log;
use Inside\Notify\Models\Notification;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\User\Events\UserDisabledEvent;

/**
 * User login listener
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class UserDisabledListener implements ShouldQueue
{
    /**
     * @param  UserDisabledEvent  $event
     * @throws Exception
     */
    public function handle(UserDisabledEvent $event): void
    {
        Log::info('[user-disabled] Suppression des notifications de <'.$event->userUuid.'>');
        Notification::where('user_uuid', $event->userUuid)->delete();
        Log::info('[user-disabled] Suppression des inscriptions aux notifications de <'.$event->userUuid.'>');
        NotificationSubscriber::where('user_uuid', $event->userUuid)->delete();
    }
}
