<?php

namespace Inside\Notify\Listeners;

use Exception;
use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Notify\Models\Notification;
use Inside\Notify\Models\NotificationType;
use Inside\Reaction\Events\ReactionSubscribedEvent;
use Inside\Reaction\Events\ReactionUnsubscribedEvent;

/**
 * Reaction unsuscribed listener
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ReactionUnsubscribedListener extends BaseNotificationListener implements ShouldQueue
{
    /**
     * @param  ReactionUnsubscribedEvent  $event
     * @throws Exception
     */
    public function handle(ReactionUnsubscribedEvent $event): void
    {
        $reaction = $event->reaction;
        $model = $reaction->reactionable;

        $types = NotificationType::where([
            'event'  => 'Inside\Reaction\Events\ReactionSubscribedEvent',
            'model'  => $reaction->reactionable_type,
            'action' => $reaction->type,
        ])->get();
        if ($types->isEmpty()) {
            $types = NotificationType::where(
                [
                    'event'  => ReactionSubscribedEvent::class,
                    'model'  => null,
                    'action' => $reaction->type,
                ]
            )->get();
        }

        foreach ($types as $type) {
            if (($reaction->type != $type->action)
                || ($type->model && $type->model != $reaction->reactionable_type)
            ) {
                continue;
            }

            $type->subscribers->each(function ($subscriber) use ($type, $model, $reaction) {
                if ($subscriber->uuid === $reaction->user_uuid) {
                    return;
                }

                $this->when = $this->getInterval($type, $model);
                $this->route = $subscriber;

                if (! $this->checkConditions($type, $model, $subscriber) ||
                    ! $this->checkUniqueness($type, $model, $subscriber)
                ) {
                    return;
                }

                Notification::where([
                    'user_uuid'            => $subscriber->uuid,
                    'notifiable_uuid'      => $model->uuid,
                    'notification_type_id' => $type->id,
                ])->delete();
            });
        }
    }
}
