<?php

namespace Inside\Notify\Listeners;

use Illuminate\Http\Request;
use Inside\Authentication\Facades\Authentication;
use Inside\Events\InsideBooted;
use Inside\Facades\Inside;
use Inside\Notify\Facades\OneSignal;

class PushNotificationListener
{
    public function handle(InsideBooted $event): void
    {
        /** @var Request $request */
        $request = request();
        $user = Authentication::getUserFromMagicCookie($request);
        if ($user) {
            $message = 'welcomeNotification: { "message": "'.__('notifications.onesignal.welcome.message', [], $user->langcode).'",}';

            if (OneSignal::isAvailable() && OneSignal::isDesktopActivated()) {
                $jsScript = '
var OneSignal = window.OneSignal || [];
OneSignal.push(function() {
  OneSignal.init({
      appId: "'.OneSignal::getAppId().'",
      allowLocalhostAsSecureOrigin: true,
  });
});';
                Inside::headerJs('https://cdn.onesignal.com/sdks/OneSignalSDK.js');
                Inside::script($jsScript);
            }
        }
    }
}
