<?php

namespace Inside\Notify\Listeners;

use Illuminate\Support\Str;
use Inside\Content\Events\ContentUpdatingEvent;
use Inside\Notify\Models\NotificationType;

/**
 * Content updated listener
 *
 * NOTE: this should not be queued !
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ContentUpdatingListener extends BaseNotificationListener
{
    /**
     * @param  ContentUpdatingEvent  $event
     */
    public function handle(ContentUpdatingEvent $event): void
    {
        $model = $event->model;
        $types = NotificationType::where('model', get_class($model))->where(
            function ($query) {
                $query->where('action', 'updating');
            }
        )->get();

        foreach ($types as $type) {
            // On updating we must validate conditions AND conditions fields starting with a '*' should be dirty
            $conditions = explode('|', $type->condition);
            foreach ($conditions as $condition) {
                $condition = explode(':', $condition);
                if (Str::startsWith($condition[0], '*')) {
                    $condition[0] = substr($condition[0], 1);
                    if (! $model->isDirty($condition[0])) {
                        continue 2; // Let's test another type
                    } elseif (count($condition) == 2) {
                        $value = $condition[1];

                        // cast value
                        if ($value == 'true') {
                            $value = true;
                        } elseif ($value == 'false') {
                            $value = false;
                        } elseif ($value == 'null') {
                            $value = null;
                        }

                        if ($model->{$condition[0]} !== $value) {
                            // Failed: we wanted $condition[0] to change value tp $condition[1]
                            continue 2; // Let's test another type
                        }
                    }
                }
            }

            // Here we passed updating conditions let's fall back to updated system
            foreach ($type->subscribers as $subscriber) {
                if (! Str::contains($type->condition, 'author:CURRENT_USER') && ($subscriber->uuid === $model->author)) {
                    continue;
                }

                $this->when = $this->getInterval($type, $model);
                $this->route = $subscriber;

                if (! $this->checkConditions($type, $model, $subscriber) ||
                    ! $this->checkUniqueness($type, $model, $subscriber)
                ) {
                    continue;
                }

                $this->notify($type, $subscriber, $model, ['from' => $model->author]);
            }
        }
    }
}
