<?php

namespace Inside\Notify\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Events\ContentUpdatedEvent;
use Inside\Notify\Models\NotificationType;

/**
 * Content updated listener
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ContentUpdatedListener extends BaseNotificationListener implements ShouldQueue
{
    /**
     * @param  ContentUpdatedEvent  $event
     */
    public function handle(ContentUpdatedEvent $event): void
    {
        $model = $event->model;

        $types = NotificationType::where('model', get_class($model))->where(function ($query) {
            $query->where('action', 'update')->orWhere('action', 'createOrUpdate');
        })->get();

        foreach ($types as $type) {
            $type->subscribers->each(function ($subscriber) use ($type, $model) {
                if ($subscriber->uuid === $model->author) {
                    return;
                }

                $this->when = $this->getInterval($type, $model);
                $this->route = $subscriber;

                if (! $this->checkConditions($type, $model, $subscriber) ||
                    ! $this->checkUniqueness($type, $model, $subscriber)
                ) {
                    return;
                }

                $this->notify($type, $subscriber, $model, ['from' => $model->author]);
            });
        }
    }
}
