<?php

namespace Inside\Notify\Listeners;

use Exception;
use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Content\Events\ContentDeletedEvent;
use Inside\Notify\Models\Notification;

/**
 * Content deleted listener
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ContentDeletedListener implements ShouldQueue
{
    /**
     * @param  ContentDeletedEvent  $event
     * @throws Exception
     */
    public function handle(ContentDeletedEvent $event): void
    {
        Notification::where('notifiable_uuid', $event->model->uuid)->delete();
    }
}
