<?php

namespace Inside\Notify\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Authentication\Events\AuthenticationLoginEvent;
use Inside\Authentication\Models\User;
use Inside\Notify\Models\NotificationType;

/**
 * User login listener
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class AuthenticationLoginListener extends BaseNotificationListener implements ShouldQueue
{
    /**
     * @param  AuthenticationLoginEvent  $event
     */
    public function handle(AuthenticationLoginEvent $event): void
    {
        $types = NotificationType::where('action', 'login')->get();
        $model = $event->user->information;

        foreach ($types as $type) {
            $type->subscribers->each(function ($subscriber) use ($type, $model) {
                $this->when = $this->getInterval($type, $subscriber);
                $this->route = $subscriber;

                if (! $this->checkConditions($type, $model, $subscriber) ||
                    ! $this->checkUniqueness($type, $model, $subscriber)) {
                    return;
                }

                $this->notify($type, $subscriber, $model, ['from' => $model->uuid]);
            });
        }
    }
}
