<?php

namespace Inside\Notify\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Str;
use Inside\Content\Models\Content;
use Inside\Jobs\Bus\Dispatchable;
use Inside\Jobs\Job;
use Inside\Notify\Listeners\NotificationManualsListener;
use Inside\Notify\Models\NotificationType;

/**
 * Class SendManualNotifications
 */
class SendManualNotifications extends Job implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable;

    private string $jobId;

    public function __construct(
        private string $channel,
        private array $roleIds,
        private Content $content,
        private NotificationType $notificationType
    ) {
        $this->jobId = (string) Str::uuid();
    }

    public function handle(): void
    {
        /**
         * @var NotificationManualsListener $notificationManualsListener
         */
        $notificationManualsListener = app(NotificationManualsListener::class);

        $notificationManualsListener->dispatchNotificationSending(
            $this->channel,
            $this->roleIds,
            $this->content,
            $this->notificationType,
            $this->jobId
        );
    }

    public function getJobId(): string
    {
        return $this->jobId;
    }
}
