<?php

namespace Inside\Notify\Console;

use Illuminate\Console\Command;
use Inside\Content\Models\Contents\Users;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;

/**
 * Command to subscribe base notifications.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class SubscribeBaseNotificationsCommand extends Command
{
    /**
     * @var string
     */
    protected $name = 'notifications:subscribe';

    /**
     * @var string
     */
    protected $description = 'Subscribe user to base notification';

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'notifications:subscribe';

    public function handle(): void
    {
        $users = Users::all();
        $notificationsTypeIds = NotificationType::where('default', true)->pluck('id')->all();

        foreach ($users as $user) {
            foreach ($notificationsTypeIds as $notificationsTypeId) {
                NotificationSubscriber::firstOrCreate([
                    'user_uuid' => $user->uuid,
                    'notification_type_id' => $notificationsTypeId,
                ]);
            }
        }
    }
}
