<?php

namespace Inside\Notify\Console;

use Inside\Console\Command;

class InstallOneSignalSDKWorkerAssetsCommand extends Command
{
    protected $signature = 'inside:onesignal:install';

    protected $description = 'Install One Signal assets';

    /** @var array */
    protected $fileToCopy = [
        'public/OneSignalSDKWorker.js' => [
            'overwrite' => true,
            'path' => 'vendor/maecia/inside/notify/resources/js/OneSignalSDKWorker.js',
        ],
        'public/OneSignalSDKUpdaterWorker.js' => [
            'overwrite' => true,
            'path' => 'vendor/maecia/inside/notify/resources/js/OneSignalSDKUpdaterWorker.js',
        ],
    ];

    public function handle(): void
    {
        $this->line('Copie des fichiers nécessaires');
        foreach ($this->fileToCopy as $path => $info) {
            if ((! $this->laravel->make('files')->exists(cms_base_path($path)) || $info['overwrite'])
                && $this->laravel->make('files')->exists(dirname(cms_base_path($path)))
            ) {
                $this->write(
                    'Copie du fichier <fg=magenta>['.cms_base_path($info['path']).
                    ']</fg=magenta> => <fg=cyan>['.cms_base_path($path).']</fg=cyan>'
                );
                $this->writeResult(
                    $this->laravel
                        ->make('files')
                        ->copy(cms_base_path($info['path']), cms_base_path($path))
                );
            }
        }
        $this->info('One Signal prêt à fonctionner');
    }
}
