<?php

namespace Inside\Notify\Console;

use Illuminate\Console\Command;
use Inside\Notify\Models\Notification;
use Inside\User\Models\User;

/**
 * Command to delete user's notifications.
 *
 * Example:
 *     > php artisan notif:delete 504777aa-b044-4102-af59-a3f244d0b030
 *                                --id=44c086d5-c40a-4b56-af76-69bb a1ae305d
 *                                --id=0e5eb970-689f-4098-a231-571d24d13090
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class DeleteUserNotificationsCommand extends Command
{
    public const EXIT_CODE__FAILED = -1;

    public const EXIT_CODE__SUCCESS = 1;

    /**
     * @var string
     */
    protected $name = 'notif:delete {user} {--id=*}';

    /**
     * @var string
     */
    protected $description = 'Delete user\'s notifications';

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'notif:delete
                        {user : The ID of the user}
                        {--id=* : Id(s) of the notifications to delete (delete all if empty)}';

    /**
     * @inheritDoc
     */
    public function handle(): int
    {
        /** @var string $uuid */
        $uuid = $this->argument('user');
        $user = User::find($uuid);
        if (! $user) {
            $this->error('User not found!');

            return self::EXIT_CODE__FAILED;
        }

        $this->info('Removing notifications from User '.$user->name);

        $notificationIds = $this->option('id');
        try {
            if (! empty($notificationIds)) {
                $countDeletedNotifications = Notification::where('user_uuid', $user->uuid)
                    ->whereIn('id', $notificationIds)
                    ->delete();
            } else {
                $countDeletedNotifications = Notification::where('user_uuid', $user->uuid)->delete();
            }
        } catch (\Exception $e) {
            $this->error($e->getMessage());

            return self::EXIT_CODE__FAILED;
        }

        $this->info($countDeletedNotifications.' notifications deleted.');

        return self::EXIT_CODE__SUCCESS;
    }
}
