<?php

namespace Inside\Notify\Console;

use Illuminate\Console\Command;
use Inside\Notify\Jobs\Cleanup;
use Inside\Notify\Models\Notification;

/**
 * Command to dispatch Cleanup job
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class CleanupCommand extends Command
{
    /**
     * @var string
     */
    protected $name = 'inside:notif:cleanup';

    /**
     * @var string
     */
    protected $description = 'Clean up notifications';

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'inside:notif:cleanup';

    /**
     * @inheritDoc
     */
    public function handle(): void
    {
        Cleanup::dispatch();
    }
}
