<?php

namespace Inside\Notify\Console;

use Illuminate\Console\Command;
use Inside\Notify\Models\Notification;

/**
 * Command to clean notifications where the associated content has been deleted.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class CleanNotificationsCommand extends Command
{
    /**
     * @var string
     */
    protected $name = 'notif:clean';

    /**
     * @var string
     */
    protected $description = 'Clean notifications';

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'notif:clean';

    /**
     * @inheritDoc
     */
    public function handle(): void
    {
        $notifications = Notification::all();

        foreach ($notifications as $notification) {
            $data = $notification->toArray();

            if ($data['notifiable_type'] && $data['notifiable_uuid']) {
                if ($data['notifiable_type'] == 'Inside\Authentication\Models\User') {
                    $data['notifiable_type'] = 'Inside\Content\Models\Contents\Users';
                }

                $query = call_user_func($data['notifiable_type'].'::withoutGlobalScopes');
                $content = $query->where('uuid', $data['notifiable_uuid'])->first();

                if (! $content) {
                    $notification->delete();
                }
            }
        }
    }
}
