<?php

namespace Inside\Notify\Concerns;

use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Notifications\RoutesNotifications;
use Inside\Notify\Models\Notification;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;

/**
 * Notification trait
 *
 * @category Trait
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
trait Notifiable
{
    use RoutesNotifications;

    /**
     * Check if the current user has to be notified for the given notification_type_id
     *
     * @param int $notificationTypeId
     * @return bool
     */
    public function hasToBeNotified(int $notificationTypeId): bool
    {
        $subscriber = NotificationSubscriber::where([
            'user_uuid'            => $this->uuid,
            'notification_type_id' => $notificationTypeId,
        ])->first();

        if ($subscriber) {
            return true;
        }

        return false;
    }

    /**
     * Get the entity's notifications.
     */
    public function notifications(): mixed
    {
        return $this->hasMany(Notification::class, 'user_uuid', 'uuid')
            ->orderBy('created_at', 'desc');
    }

    /**
     * Get user subscriptions
     */
    public function subscriptions(): mixed
    {
        return $this->belongsToMany(NotificationType::class, 'inside_notifications_subscribers');
    }
}
