<?php

namespace Inside\Notify\Channels;

use Exception;
use Illuminate\Support\Facades\Log;
use Inside\Authentication\Models\User;
use Inside\Notify\Facades\SMS;
use Inside\Notify\Notifications\SmsNotification;

/**
 * SMS channel.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class SmsChannel
{
    /**
     * @param User $notifiable
     * @param SmsNotification $notification
     * @throws Exception
     */
    public function send(User $notifiable, SmsNotification $notification): void
    {
        try {
            Log::info('[SmsChannel::send] sending sms to <'.$notifiable->uuid.'>');
            SMS::send($notification->setUser($notifiable)->toSms());
        } catch (Exception $exception) {
            Log::error('[SmsChannel::send] failed to send sms <'.$exception->getMessage().'>');
            throw $exception;
        }
    }
}
