<?php

namespace Inside\Notify\Channels;

use Illuminate\Notifications\Channels\SlackWebhookChannel as BaseSlackChannel;
use Illuminate\Notifications\Notification;
use Psr\Http\Message\ResponseInterface;

/**
 * Slack channel.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class SlackChannel extends BaseSlackChannel
{
    public function send($notifiable, Notification $notification): ?ResponseInterface
    {
        if (! $url = $notifiable->routeNotificationFor('slack')) {
            return null;
        }

        return $this->http->post(
            $url,
            $this->buildJsonPayload(
                $notification->toSlack()
            )
        );
    }
}
