<?php

namespace Inside\Notify;

use Illuminate\Contracts\Bus\Dispatcher as Bus;
use Illuminate\Contracts\Events\Dispatcher;
use Illuminate\Notifications\ChannelManager as BaseChannelManager;

class ChannelManager extends BaseChannelManager
{
    public function send($notifiables, $notification)
    {
        (new NotificationSender(
            $this,
            $this->app->make(Bus::class),
            $this->app->make(Dispatcher::class)
        )
        )->send($notifiables, $notification);
    }

    /**
     * Send the given notification immediately.
     *
     * @param  \Illuminate\Support\Collection|array|mixed  $notifiables
     * @param  mixed  $notification
     * @param  array|null  $channels
     * @return void
     */
    public function sendNow($notifiables, $notification, array $channels = null): void
    {
        (new NotificationSender(
            $this,
            $this->app->make(Bus::class),
            $this->app->make(Dispatcher::class)
        )
        )->sendNow($notifiables, $notification, $channels);
    }
}
