<?php

namespace Inside\Notify\Seeders;

use Illuminate\Database\Seeder;
use Inside\Content\Models\Contents\Users;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;

class SeniorityAnniversaryNotificationSeeder extends Seeder
{
    public function run()
    {
        $notificationType = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => '',
                'model' => '',
                'action' => 'seniorityAnniversary',
                'type' => 'global',
                'condition' => '',
                'multiple' => false,
                'language' => true,
                'profile' => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.seniority_anniversary.title',
                    'description' => 'notifications.seniority_anniversary.description',
                    'text' => 'notifications.seniority_anniversary.text',
                    'fields' => [
                        'notification-data.from' => ['firstname', 'lastname'],
                    ],
                ],
            ]
        );

        if ($notificationType) {
            Users::all()->each(function ($user) use ($notificationType) {
                NotificationSubscriber::firstOrCreate([
                    'user_uuid' => $user->uuid,
                    'notification_type_id' => $notificationType->id,
                ]);
            });
        }
    }
}
