<?php

use Illuminate\Database\Seeder;
use Inside\Content\Models\Contents\Users;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;
use Inside\Notify\Models\NotificationTypeRole;
use Inside\Permission\Models\Role;

class RecentsActivitiesSeeder extends Seeder
{
    public function run()
    {
        // Clean old activity notification
        NotificationType::where('type', 'activity')->delete();

        // Prénom Nom a commenté l'actualité titre de l'actualité
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => 'Inside\Content\Events\ContentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\Comments',
                'action' => 'contentCommented',
                'type' => 'activity',
                'condition' => 'parent_type:news',
                'multiple' => false,
                'language' => true,
                'profile' => false,
                'role' => true,
            ],
            [
                'data' => [
                    'title' => 'notifications.activity.create.comment.news.title',
                    'description' => 'notifications.activity.create.comment.news.description',
                    'text' => 'notifications.activity.create.comment.news.text',
                    'fields' => ['title'],
                    'url' => 'RELATION:news',
                ],
            ]
        );

        // Prénom Nom a commenté l'évènement titre de l'évènement
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => 'Inside\Content\Events\ContentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\Comments',
                'action' => 'contentCommented',
                'type' => 'activity',
                'condition' => 'parent_type:events',
                'multiple' => false,
                'language' => true,
                'profile' => false,
                'role' => true,
            ],
            [
                'data' => [
                    'title' => 'notifications.activity.create.comment.events.title',
                    'description' => 'notifications.activity.create.comment.events.description',
                    'text' => 'notifications.activity.create.comment.events.text',
                    'fields' => ['title'],
                    'url' => 'RELATION:events',
                ],
            ]
        );

        // Prénom Nom a ajouté une ressource
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => 'Inside\Content\Events\ContentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\Documents',
                'action' => 'create',
                'type' => 'activity',
                'condition' => '',
                'multiple' => false,
                'language' => true,
                'profile' => false,
                'role' => true,
            ],
            [
                'data' => [
                    'title' => 'notifications.activity.create.documents.title',
                    'description' => 'notifications.activity.create.documents.description',
                    'text' => 'notifications.activity.create.documents.text',
                    'fields' => [
                        'title',
                        'slug',
                    ],
                    'url' => 'GED:folders',
                ],
            ]
        );

        // Prénom Nom a ajouté un évènement
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => 'Inside\Content\Events\ContentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\Events',
                'action' => 'create',
                'type' => 'activity',
                'condition' => '',
                'multiple' => false,
                'language' => true,
                'profile' => false,
                'role' => true,
            ],
            [
                'data' => [
                    'title' => 'notifications.activity.create.events.title',
                    'description' => 'notifications.activity.create.events.description',
                    'text' => 'notifications.activity.create.events.text',
                    'fields' => [
                        'title',
                        'slug',
                    ],
                ],
            ]
        );

        // Prénom Nom a ajouté l'actualité
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => 'Inside\Content\Events\ContentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\News',
                'action' => 'create',
                'type' => 'activity',
                'condition' => '',
                'multiple' => false,
                'language' => true,
                'profile' => false,
                'role' => true,
            ],
            [
                'data' => [
                    'title' => 'notifications.activity.create.news.title',
                    'description' => 'notifications.activity.create.news.description',
                    'text' => 'notifications.activity.create.news.text',
                    'fields' => [
                        'title',
                        'slug',
                    ],
                ],
            ]
        );
        $notificationType = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => 'Inside\Content\Events\ContentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\News',
                'action' => 'create',
                'type' => 'activity',
                'condition' => '',
                'multiple' => false,
                'language' => true,
                'profile' => false,
                'role' => true,
            ],
            [
                'data' => [
                    'title' => 'notifications.news.create.title',
                    'description' => 'notifications.news.create.description',
                    'text' => 'notifications.news.create.text',
                    'fields' => [
                        ['walls' => ['title', 'slug']],
                    ],
                ],
            ]
        );

        $authenticatedRole = Role::where('name', 'authenticated')->first();
        foreach ($notificationTypes as $notificationType) {
            if ($notificationType) {
                Users::all()->each(
                    function ($user) use ($notificationType) {
                        NotificationSubscriber::firstOrCreate(
                            [
                                'user_uuid' => $user->uuid,
                                'notification_type_id' => $notificationType->id,
                            ]
                        );
                    }
                );

                $this->command->info('Notifications created, '.Users::count().' subscribers');

                if ($authenticatedRole) {
                    NotificationTypeRole::firstOrCreate(
                        [
                            'role_id' => $authenticatedRole->id,
                            'notification_type_id' => $notificationType->id,
                        ]
                    );
                    $this->command->info('Role "authenticated" subscribed.');
                }

                continue;
            }
            $this->command->info('Notifications created, no subscribers');
        }

        $this->command->info('Notification type created');
    }
}
