<?php

use Illuminate\Database\Seeder;
use Inside\Authentication\Models\User;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;

class MakeStagingSafeWithNoMailNotificationSeeder extends Seeder
{
    public function run()
    {
        // Remove subscribers from email notification type for staging and test servers
        NotificationType::where('via', 'email')->each(function ($type) {
            NotificationSubscriber::where([
                'notification_type_id' => $type->id,
            ])->delete();
        });
    }
}
