<?php

use Illuminate\Database\Seeder;
use Inside\Authentication\Models\User;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;

class FixDefaultNotificationTypes extends Seeder
{
    public function run()
    {
        NotificationType::where('default', true)->each(function ($type) {
            User::each(function ($user) use ($type) {
                NotificationSubscriber::firstOrCreate([
                    'user_uuid'            => $user->uuid,
                    'notification_type_id' => $type->id,
                ]);
            });
        });
    }
}
