<?php

use Illuminate\Database\Seeder;
use Inside\Content\Models\Contents\Users;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;

class CommentsNotificationSeeder extends Seeder
{
    public function run()
    {
        $this->command->info('Creating comments notification type');

        $notificationTypes = [];

        // Someone commented a user content
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'default'   => true,
                'event'     => 'Inside\Content\Events\CommentCreatedEvent',
                'model'     => 'Inside\Content\Models\Contents\Comments',
                'action'    => 'contentCommented',
                'type'      => 'global',
                'condition' => 'parent_type:news,events,documents|author:CURRENT_USER',
                'multiple'  => true,
                'language'  => false,
                'profile'   => true,
            ],
            [
                'data' => [
                    'title'       => 'notifications.create.comment.content.title',
                    'description' => 'notifications.create.comment.content.description',
                    'icon'        => 'comment',
                    'text'        => 'notifications.create.comment.content.<content_type>.text',
                    'fields'      => [
                        'title',
                        'content_type',
                    ],
                ],
            ]
        );

        // Someone answer someone else comment
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'default'   => true,
                'event'     => 'Inside\Content\Events\CommentCreatedEvent',
                'model'     => 'Inside\Content\Models\Contents\Comments',
                'action'    => 'commentCommented',
                'type'      => 'global',
                'condition' => 'author:CURRENT_USER',
                'multiple'  => true,
                'language'  => false,
                'profile'   => true,
            ],
            [
                'data' => [
                    'title'       => 'notifications.create.comment.comment.title',
                    'description' => 'notifications.create.comment.comment.description',
                    'icon'        => 'comment',
                    'text'        => 'notifications.create.comment.comment.<content_type>.text',
                    'fields'      => [
                        'title',
                        'content_type',
                    ],
                ],
            ]
        );

        foreach ($notificationTypes as $notificationType) {
            Users::all()->each(
                function ($user) use ($notificationType) {
                    NotificationSubscriber::firstOrCreate(
                        [
                            'user_uuid'            => $user->uuid,
                            'notification_type_id' => $notificationType->id,
                        ]
                    );
                }
            );
            $this->command->info('Notifications created, '.Users::count().' subscribers');
        }
    }
}
