<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

final class AddNotificationLogs extends Migration
{
    public function up(): void
    {
        Schema::create('inside_notification_logs', function (Blueprint $table) {
            $table->increments('id');
            $table->uuid('queued_job_id')->nullable();
            $table->string('content_type');
            $table->uuid('content_uuid');
            $table->timestamp('sent_at');
            $table->string('channel');
            $table->json('roles')->nullable();
            $table->tinyInteger('status')->default(0);
            $table->timestamps();
        });
    }
}
