<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Users;
use Inside\Database\Migrations\HasConsole;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;

class CreateManualNotificationTypes extends Migration
{
    use HasConsole;

    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (config('app.code') === 'club') {
            return;
        }

        collect(['web', 'email'])->each(function (string $via) {
            $notificationType = NotificationType::firstOrCreate(
                [
                    'via'       => $via,
                    'default'   => true,
                    'event'     => '',
                    'model'     => '',
                    'action'    => 'manualNotificationsSend',
                    'type'      => 'global',
                    'condition' => '',
                    'multiple'  => true,
                    'language'  => false,
                    'profile'   => true,
                ],
                [
                    'data' => [
                        'title'       => 'notifications.subscription.manual.title',
                    ],
                ]
            );

            $userUuids = Users::pluck('uuid');

            $crossJoinData = $userUuids->crossJoin([$notificationType->id])->map(
                fn ($item) => [
                    'user_uuid'            => $item[0],
                    'notification_type_id' => $item[1],
                ]
            );

            NotificationSubscriber::insert($crossJoinData->toArray());
        });
    }
}
